(**********************************************************************************************)
(*  RobStores.pas - Copyright 2016-10-23 by DirtRider                                         *)
(*  For use with Mike's Menu 1.36 Extended                                                    *)
(*  http://pastebin.com/RiLpN5TN                                                              *)
(*                                                                                            *)
(*  Change the Key constants below to match your keyboard settings                            *)
(*                                                                                            *)
(*  Save this file into your Mike's scripts folder and name it 'RobStores.pas'                *)
(*  Add the following line to your menu.xml under the menu_scripts section                    *)
(*    <Entry type="script" action="script_RobStores.pas">Rob Stores</Entry>                   *)
(*                                                                                            *)
(**********************************************************************************************)
 
const
  ForwardKey    = 'W';     // To move forward slightly to triger TP
  LightMeleeKey = 'R';     // To punch clerk (whatever key punches when you have no weapon selected)
  ActionKey     = 'E';     // To steal cash from register
 
   
(**********************************************************************************************)
(* Don't change anything below this line, unless you really want to ;)                        *)
(**********************************************************************************************)
 
  TPDelay        = 5000; // Milliseconds (1000 = 1 second)
  PostPunchDelay = 1000;
  CashDelay      = 6000;
   
 
type
  TLocation = record
    X : single;
    Y : single;
    Z : single;
   end;
     
  TStates = (Init, TP1, PostTP1, PunchDelay, Punching, PreTP2, TP2, GetCash, GetCashDelay);
 
var
  State             : TStates;
  TPIndex           : Integer;
  PlayerName        : String;
  Pos,LastPos       : TLocation;
  LastMoveTicks     : Cardinal;
  LastStateTicks    : Cardinal;
  FailedTPs         : Integer;
  FaildStills       : Integer;
  Locations         : array[0..19] of TLocation;
  NoMoveCount         : Integer;
 
(**********************************************************************************************)
(**********************************************************************************************)
   
procedure GetPos;
begin
  ReadPropertyFloat('Player.Position.X', Pos.X);
  ReadPropertyFloat('Player.Position.Y', Pos.Y);
  ReadPropertyFloat('Player.Position.Z', Pos.Z);
end;
   
(**********************************************************************************************)
 
function LocationsNear(Loc1,Loc2:TLocation;NearDist:Single):Boolean;
begin
  Result :=
    (abs(Loc1.X-Loc2.X) <= NearDist) and
    (abs(Loc1.Y-Loc2.Y) <= NearDist) and
    (abs(Loc1.Z-Loc2.Z) <= NearDist);
end;
 
(**********************************************************************************************)
 
Function StillSince(ms:Cardinal):Boolean;
begin
  if not LocationsNear(Pos,LastPos,0.001) then
   begin // Moved
    LastMoveTicks := GetTickCount;   
    Result := False;
   end
  else // Didn't move
    Result := GetTickCount-LastMoveTicks >= ms;
end;
   
(**********************************************************************************************)
 
function LocToStr(Loc:tLocation):String;
begin
  Result := FloatToStr(Loc.X)+';'+FloatToStr(Loc.Y)+';'+FloatToStr(Loc.Z);
end;
 
(**********************************************************************************************)
 
procedure TPToLocation(Loc:tLocation);
begin
  call('Teleport',LocToStr(Loc));
  sleep(100);
  call('SendKey',ForwardKey); // move forward a little to trigger TP  
end;
 
(**********************************************************************************************)
 
procedure SetState(aState:TStates);
begin
  State := aState;
  LastStateTicks := GetTickCount;
end;
 
(**********************************************************************************************)
 
procedure DoInit;
begin
  // Setup locations
  // These are in order so that when TPing, will be in a relatively good position
  // to punch the clerk
  With Locations[0] do begin X:=1728.939453; Y:=6417.329590; Z:=35.037254; end;
  With Locations[1] do begin X:=1697.993408;Y:=4922.928223;Z:=42.063656; end;
  With Locations[2] do begin X:=549.364563;Y:=2668.990723;Z:=42.156536; end;
  With Locations[3] do begin X:=1392.907227;Y:=3606.402344;Z:=34.980904; end;
  With Locations[4] do begin X:=2675.962646;Y:=3280.569824;Z:=55.241150; end;
  With Locations[5] do begin X:=-2966.458740;Y:=390.867554;Z:=15.043311; end;
  With Locations[6] do begin X:=1165.972046;Y:=2710.771240;Z:=38.157703; end;
  With Locations[7] do begin X:=373.154144;Y:=328.713257;Z:=103.566376; end;
  With Locations[8] do begin X:=-3244.615967;Y:=1000.194763;Z:=12.830716; end;
  With Locations[9] do begin X:=-1820.089722;Y:=794.142334;Z:=138.088852; end;
  With Locations[10] do begin X:=1134.249390;Y:=-982.474976;Z:=46.415825; end;
  With Locations[11] do begin X:=-3041.203613;Y:=583.831116;Z:=7.908930; end;
  With Locations[12] do begin X:=-46.787502;Y:=-1757.964844;Z:=29.421003; end;
  With Locations[13] do begin X:=24.481058;Y:=-1344.968140;Z:=29.497044; end;
  With Locations[14] do begin X:=2554.865723;Y:=380.929352;Z:=108.622971; end;
  With Locations[15] do begin X:=-706.142273;Y:=-913.673279;Z:=19.215599; end;
  With Locations[16] do begin X:=1958.922607;Y:=3742.100586;Z:=32.343781; end;
  With Locations[17] do begin X:=-1222.012817;Y:=-908.295898;Z:=12.326356; end;
  With Locations[18] do begin X:=1164.683472;Y:=-322.764343;Z:=69.205101; end;
  With Locations[19] do begin X:=-1486.287109;Y:=-378.039948;Z:=40.163422; end;
  LastMoveTicks := GetTickCount;
  TPIndex := low(Locations);
  FailedTPs := 0;
  FaildStills := 0;
  NoMoveCount := 0;
end;
 
(**********************************************************************************************)
(**********************************************************************************************)
 
begin // main
  GetPos;
  //    Init, TP1, PostTP1, PunchDelay, Punching, PreTP2, TP2, GetCash, GetCashDelay
  case State of
    Init:
     begin
      DoInit;
      SetState(TP1);
     end;
 
    TP1:
     begin
      if StillSince(250) then
       begin
        TPToLocation(Locations[TPIndex]);
        SetState(PostTP1);
        FaildStills := 0;
       end
      else
        Inc(FaildStills);
      if FaildStills >= 40 then // Failed for 10 seconds
       begin
        WritePropertyFloat('PLAYER.HEALTH',0); // Suicide!
        FaildStills := 0;
        sleep(TPDelay);
       end;
      sleep(250);
     end;
   
    PostTP1:
     begin
      if LocationsNear(Pos,Locations[TPIndex],1.0) then
       begin
        FailedTPs := 0;
        SetState(PunchDelay);
       end
      else if (GetTickCount-LastStateTicks) >= TPDelay then
       begin // TP Failed?
        Inc(FailedTPs);
        if FailedTPs >= 6 then // Failed 6 times, must be frozen
         begin
          WritePropertyFloat('PLAYER.HEALTH',0); // Suicide!
          FailedTPs := 0;
          sleep(TPDelay);
         end;
        if FailedTPs = 3 then // Failed 3 times, move to next location
         begin
          inc(TPIndex);
          if TPIndex > 19 then
            TPIndex := 0;                
         end;
        SetState(TP1); // Retry TP
       end;
     end;
   
    PunchDelay:
     begin
      if (GetTickCount-LastStateTicks) >= TPDelay then
        SetState(Punching);
     end;
 
    Punching:
     begin
      call('SendKey',LightMeleeKey);
      sleep(PostPunchDelay);
      SetState(PreTP2);
     end;
 
    PreTP2:
     begin
      // check if close to register, if not TP back to it
      if LocationsNear(Pos,Locations[TPIndex],0.25)  then
        SetState(GetCash)
      else
        SetState(TP2);
     end;
 
    TP2:
     begin
      if StillSince(250) then
       begin
        TPToLocation(Locations[TPIndex]);
        SetState(GetCash);
       end;
     end;
 
    GetCash:
     begin
      // Check if exactly at the TP spot which might mean we're frozen
      if (Pos <> Locations[TPIndex]) then
        NoMoveCount := 0
      else
        inc(NoMoveCount);
      if NoMoveCount >= 3 then
       begin // haven't budged in last 3 TP requests so probably frozen
        WritePropertyFloat('PLAYER.HEALTH',0); // Suicide!
        //sleep(5000);
        NoMoveCount := 0;
       end
      else
       begin // Get cash!!
        call('SendKey',ActionKey);
        SetState(GetCashDelay);
       end;
     end;
 
    GetCashDelay:
     begin
      if (GetTickCount-LastStateTicks) >= CashDelay then
       begin
        inc(TPIndex);
        if TPIndex > 19 then
          TPIndex := 0;
        SetState(TP1);
       end;
     end;
         
   end; // case
 
  LastPos := Pos;
end.